<?php
/**
 * This file generates the header for the back-end and also for the default
 * template.
 *
 * Other checks for user level are performed later to generate the different
 * menu items, and the content of the page that called this file.
 *
 * @package ProjectSend
 * @see check_for_session
 * @see can_see_content
 */
/** Check for an active session or cookie */
check_for_session();

/**
 * Check if the current user has permission to view this page.
 * If not, an error message is generated instead of the actual content.
 * The allowed levels are defined on each individual page before the
 * inclusion of this file.
 */
can_see_content($allowed_levels);

global $flash;

/** If no page title is defined, revert to a default one */
if (!isset($page_title)) { $page_title = __('System Administration','cftp_admin'); }

if (!isset($body_class)) { $body_class = array(); }

if ( !empty( $_COOKIE['menu_contracted'] ) && $_COOKIE['menu_contracted'] == 'true' ) {
	$body_class[] = 'menu_contracted';
}

$body_class[] = 'menu_hidden';

/**
 * Silent updates that are needed even if no user is logged in.
 */
require_once INCLUDES_DIR . DS .'core.update.silent.php';

/**
 * Call the database update file to see if any change is needed,
 * but only if logged in as a system user.
 */
$core_update_allowed = array(9,8,7);
if (current_role_in($core_update_allowed)) {
	require_once INCLUDES_DIR . DS . 'core.update.php';
}

password_change_required();
?>
<!doctype html>
<html lang="<?php echo SITE_LANG; ?>">
<head>
    <meta charset="<?php echo(CHARSET); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<title><?php echo html_output( $page_title . ' &raquo; ' . htmlspecialchars(get_option('this_install_title'), ENT_QUOTES, CHARSET) ); ?></title>
	<?php meta_favicon(); ?>

	<?php
		require_once INCLUDES_DIR . DS . 'assets.php';

        load_js_header_files();
		load_css_files();
	?>
</head>

<body <?php echo add_body_class( $body_class ); ?> <?php if (!empty($page_id)) { echo add_page_id($page_id); } ?>>
	<div class="container-custom">
		<header id="header" class="navbar navbar-static-top navbar-fixed-top">
			<ul class="nav pull-left nav_toggler">
				<li>
					<a href="#" class="toggle_main_menu"><i class="fa fa-bars" aria-hidden="true"></i><span><?php _e('Toogle menu', 'cftp_admin'); ?></span></a>
				</li>
			</ul>

			<div class="navbar-header">
				<span class="navbar-brand"><a href="<?php echo SYSTEM_URI; ?>" target="_blank"><?php include_once 'assets/img/ps-icon.svg'; ?></a> <?php echo html_output(get_option('this_install_title')); ?></span>
			</div>

			<ul class="nav pull-right nav_account">
				<li id="header_welcome">
					<span><?php echo CURRENT_USER_NAME; ?></span>
                </li>
                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><?php _e('Language', 'cftp_admin'); ?> <span class="caret"></span></a>
                        <ul class="dropdown-menu">
                            <?php
                                // scan for language files
                                $available_langs = get_available_languages();
                                foreach ($available_langs as $filename => $lang_name) {
                            ?>
                                    <li>
                                        <a href="<?php echo BASE_URI.'process.php?do=change_language&language='.$filename; ?>">
                                            <?php echo $lang_name; ?>
                                        </a>
                                    </li>
                            <?php
                                }
                            ?>
                        </ul>
                </li>
				<li>
					<?php
						$my_account_link = (CURRENT_USER_LEVEL == 0) ? 'clients-edit.php' : 'users-edit.php';
						$my_account_link .= '?id='.CURRENT_USER_ID;
					?>
					<a href="<?php echo BASE_URI.$my_account_link; ?>" class="my_account"><i class="fa fa-user-circle" aria-hidden="true"></i> <?php _e('My Account', 'cftp_admin'); ?></a>
				</li>
				<li>
					<a href="<?php echo BASE_URI; ?>process.php?do=logout" ><i class="fa fa-sign-out" aria-hidden="true"></i> <?php _e('Logout', 'cftp_admin'); ?></a>
				</li>
			</ul>
		</header>

		<div class="main_side_menu">
			<?php
				include_once 'header-menu.php';
			?>
		</div>

		<div class="main_content">
			<div class="container-fluid">
				<?php
					// Gets the mark up and values for the System Updated and errors messages.
					include_once INCLUDES_DIR . DS . 'updates.messages.php';

					// Check if we are on a development version
					if ( IS_DEV == true ) {
				?>
						<div class="row">
							<div class="col-sm-12">
								<div class="system_msg">
									<p><strong><?php _e('System Notice:', 'cftp_admin');?></strong> <?php _e('You are using a development version. Some features may be unfinished or not working correctly.', 'cftp_admin'); ?></p>
								</div>
							</div>
						</div>
				<?php
					}

                    // Check important directories write permissions
                    $write_errors = [];
                    $directories = [
                        ADMIN_UPLOADS_DIR,
                        UPLOADED_FILES_DIR,
                        THUMBNAILS_FILES_DIR,
                    ];
                    foreach ($directories as $directory) {
                        if (!file_exists($directory)) {
                            @mkdir($directory, 0775, true);
                        }

                        if (!is_writable($directory)) {
                            $write_errors[] = $directory;
                        }
                    }

                    if ( !empty($write_errors) ) {
                        $msg = '<p><strong>'.__('Warning:', 'cftp_admin').'</strong>' . ' ' . __('The following directories do not exist or have write permissions errors.', 'cftp_admin').'</p>';
                        $msg .= '<p>'.__('File uploading or other important functions might not work.', 'cftp_admin').'</p>';
                        foreach ($write_errors as $directory) {
                            $msg .= '<p>'.$directory.'</p>';
                        }

                        echo system_message('danger', $msg);
                    }
                ?>

				<div class="row">
					<div class="col-xs-12">
					    <div id="section_title">
							<h2><?php echo $page_title; ?></h2>
						</div>
					</div>
				</div>

                <?php
                    // Flash messages
                    if ($flash->hasMessages()) {
                        echo $flash;
                    }
                ?>

				<div class="row">