export interface CoreOptions {
    transformOrigin: [string, string];
}
export interface DefaultOptions {
    transitionDuration: number;
    theme: 'black' | 'white';
}
export interface ConfigurableOptions extends Partial<DefaultOptions> {
    scope: HTMLElement;
    menuItems: MenuItem[];
    customClass?: string;
    customThemeClass?: string;
    preventCloseOnClick?: boolean;
}
export interface Options extends ConfigurableOptions, CoreOptions {
}
export interface MenuOption {
    label: string;
    callback: (ev: MouseEvent) => any;
    /**
     * @deprecated This property was replaced by the new iconHTML property
     */
    iconClass: string;
    iconHTML: string;
    preventCloseOnClick?: boolean;
}
export declare type MenuItem = MenuOption | 'hr';
